#delimit ;
cap log close ;
log using table4.log, text replace ;

set more off ;
clear ;
set seed 10104 ;

/* load up the programs. each do file has a program that will be used */

do set_directory_macros ;

set matsize 10000 ;
run t4_mcloop ;
run t4_display ;
run t34_programs ;

cap prog drop runme ;
prog def runme ;

/* initialize the file names, lists, etc, that will be passed into the pgrograms */

local start = "$S_DATE $S_TIME" ;

local num_mc_reps = 4 ;
*local mc_reps_smallG = 1000 ;
*local mc_reps_bigG = 4 ;
local mc_reps_smallG = 4000 ;
local mc_reps_bigG = 1000 ;

local num_bs_reps = 399 ;
*local num_states_list = "6 " ;
local num_states_list = "6 10 20 30 50" ;
local mysourcedata = "$madedat/CPS_panel" ;

/* prepare the state list, and ensure that all files are sorted on statefip  */
tempfile statelist mcout_all ;
qui use "`mysourcedata'" ;
cap drop resid ;
sort statefip year ;
qui save "`mysourcedata'" , replace ;
contract statefip ;
keep statefip ;
sort statefip ;
qui save "`statelist'" ;

/* now, do the Monte Carlo exercise*/
/* loop over number of states in the hum_states_list*/

cap erase `mcout_all' ;
foreach ns in `num_states_list' { ;

	local num_mc_reps = `mc_reps_bigG' ;
	if `ns' < 11 { ;
		local num_mc_reps = `mc_reps_smallG' ;
	} ;

	tempfile mcout_`ns' ;
	di ;
	di "$S_DATE $S_TIME" ;
	do_the_monte_carlo , statelist("`statelist'") sourcedata("`mysourcedata'") savedata("`mcout_`ns''")
		mcreps(`num_mc_reps') bsreps(`num_bs_reps') numstates(`ns') ;

	use `mcout_`ns'' , replace ;
	qui gen datetime = "$S_DATE $S_TIME" ;		/* keeps track of when this batch of data was generated */
	qui save "`mcout_`ns''" , replace ;

	qui save t4_mcout_G_`ns' , replace ;

} ;

tempfile toappend ;
foreach ns in `num_states_list' { ;
	clear ;
	cap erase `toappend' ;
	cap use t4_mcout_all ;
	cap drop if numstates == `ns' ;
	cap save `toappend' , replace ;
	use t4_mcout_G_`ns' ;
	cap append using `toappend' ;
	qui save t4_mcout_all , replace ;
	
} ;


/* processes the results, produces the output */
display_results , results_data(t4_mcout_all) numstates_list("`num_states_list'") ;


local stop = "$S_DATE $S_TIME" ;

di "start = `start'" ;
di "stop = `stop'" ;

end ;

runme ;


log close ;

